/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import io.github.noeppi_noeppi.libx.impl.data.DecorationTags;
import io.github.noeppi_noeppi.libx.impl.tags.InternalTagProvider;
import io.github.noeppi_noeppi.libx.impl.tags.InternalTags;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommonTagsProviderBase
implements DataProvider {
    protected final ModX mod;
    protected final DataGenerator generator;
    protected final ExistingFileHelper fileHelper;
    private final BlockTagProviderBase blockTags;
    private final ItemTagProviderBase itemTags;
    private final FluidTagProviderBase fluidTags;
    private boolean isSetup = false;
    private final List<Runnable> itemCopies = new ArrayList<Runnable>();
    private final List<Pair<TagKey<Fluid>, TagKey<Block>>> fluidCopies = new ArrayList<Pair<TagKey<Fluid>, TagKey<Block>>>();
    private boolean hasLibXInternalTags = false;

    public CommonTagsProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        this.mod = mod;
        this.generator = generator;
        this.fileHelper = fileHelper;
        this.blockTags = new BlockTagProviderBase(generator, mod.modid, fileHelper);
        this.itemTags = new ItemTagProviderBase(generator, mod.modid, fileHelper, this.blockTags);
        this.fluidTags = new FluidTagProviderBase(generator, mod.modid, fileHelper);
        generator.m_123914_((DataProvider)this.blockTags);
        generator.m_123914_((DataProvider)this.itemTags);
        generator.m_123914_((DataProvider)this.fluidTags);
    }

    public abstract void setup();

    private void doSetup() {
        if (this.getClass() == InternalTagProvider.class) {
            this.initInternalTags();
        }
        this.setup();
        ForgeRegistries.BLOCKS.getValues().stream().filter(i -> this.mod.modid.equals(Objects.requireNonNull(i.getRegistryName()).m_135827_())).forEach(block -> {
            DecorationTags.addTags(block, this, this::initInternalTags);
            this.defaultBlockTags((Block)block);
        });
        ForgeRegistries.ITEMS.getValues().stream().filter(i -> this.mod.modid.equals(Objects.requireNonNull(i.getRegistryName()).m_135827_())).forEach(this::defaultItemTags);
        ForgeRegistries.FLUIDS.getValues().stream().filter(i -> this.mod.modid.equals(Objects.requireNonNull(i.getRegistryName()).m_135827_())).forEach(this::defaultFluidTags);
    }

    public void defaultItemTags(Item item) {
    }

    public void defaultBlockTags(Block block) {
    }

    public void defaultFluidTags(Fluid fluid) {
    }

    public TagsProvider.TagAppender<Item> item(TagKey<Item> tag) {
        return this.itemTags.m_206424_(tag);
    }

    public TagsProvider.TagAppender<Block> block(TagKey<Block> tag) {
        return this.blockTags.m_206424_(tag);
    }

    public TagsProvider.TagAppender<Fluid> fluid(TagKey<Fluid> tag) {
        return this.fluidTags.m_206424_(tag);
    }

    public void copyBlock(TagKey<Block> from, TagKey<Item> to) {
        this.itemCopies.add(() -> this.itemTags.m_206421_(from, to));
    }

    public void copyFluid(TagKey<Fluid> from, TagKey<Block> to) {
        this.fluidCopies.add((Pair<TagKey<Fluid>, TagKey<Block>>)Pair.of(from, to));
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " common tags";
    }

    public void m_6865_(@Nonnull HashCache cache) {
    }

    private void initInternalTags() {
        if (!this.hasLibXInternalTags) {
            this.hasLibXInternalTags = true;
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Items.getTags().entrySet()) {
                this.item(entry.getValue());
            }
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Blocks.getTags().entrySet()) {
                this.block(entry.getValue());
            }
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Items.getCopies().entrySet()) {
                this.copyBlock(entry.getKey(), entry.getValue());
            }
        }
    }

    private class BlockTagProviderBase
    extends BlockTagsProvider {
        private Map<ResourceLocation, Tag.Builder> tagCache;

        protected BlockTagProviderBase(DataGenerator generator, String modid, ExistingFileHelper fileHelper) {
            super(generator, modid, fileHelper);
        }

        protected void m_6577_() {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.f_126543_.putAll(this.tagCache);
            }
            for (Pair<TagKey<Fluid>, TagKey<Block>> copy : CommonTagsProviderBase.this.fluidCopies) {
                TagsProvider.TagAppender<Block> builder = this.m_206424_((TagKey<Block>)((TagKey)copy.getRight()));
                for (ResourceLocation entry : CommonTagsProviderBase.this.fluidTags.getTagInfo((TagKey<Fluid>)((TagKey)copy.getLeft()))) {
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(entry);
                    if (fluid == null) continue;
                    builder.m_126582_((Object)fluid.m_76145_().m_76188_().m_60734_());
                }
            }
        }

        public void m_6865_(@Nonnull HashCache cache) {
            this.tagCache = new HashMap<ResourceLocation, Tag.Builder>(this.f_126543_);
            super.m_6865_(cache);
        }

        @Nonnull
        public TagsProvider.TagAppender<Block> m_206424_(@Nonnull TagKey<Block> tag) {
            return super.m_206424_(tag);
        }

        @Nonnull
        public String m_6055_() {
            return CommonTagsProviderBase.this.mod.modid + " common block tags";
        }
    }

    private class ItemTagProviderBase
    extends ItemTagsProvider {
        private Map<ResourceLocation, Tag.Builder> tagCache;

        protected ItemTagProviderBase(DataGenerator generator, String modid, ExistingFileHelper fileHelper, BlockTagProviderBase blockTags) {
            super(generator, (BlockTagsProvider)blockTags, modid, fileHelper);
        }

        protected void m_6577_() {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.f_126543_.putAll(this.tagCache);
            }
            for (Runnable copy : CommonTagsProviderBase.this.itemCopies) {
                copy.run();
            }
        }

        public void m_6865_(@Nonnull HashCache cache) {
            this.tagCache = new HashMap<ResourceLocation, Tag.Builder>(this.f_126543_);
            super.m_6865_(cache);
        }

        @Nonnull
        public TagsProvider.TagAppender<Item> m_206424_(@Nonnull TagKey<Item> tag) {
            return super.m_206424_(tag);
        }

        public void m_206421_(@Nonnull TagKey<Block> blockTag, @Nonnull TagKey<Item> itemTag) {
            super.m_206421_(blockTag, itemTag);
        }

        @Nonnull
        public String m_6055_() {
            return CommonTagsProviderBase.this.mod.modid + " common item tags";
        }
    }

    private class FluidTagProviderBase
    extends FluidTagsProvider {
        private Map<ResourceLocation, Tag.Builder> tagCache;

        protected FluidTagProviderBase(DataGenerator generator, String modid, ExistingFileHelper fileHelper) {
            super(generator, modid, fileHelper);
        }

        protected void m_6577_() {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.f_126543_.putAll(this.tagCache);
            }
        }

        public void m_6865_(@Nonnull HashCache cache) {
            this.tagCache = new HashMap<ResourceLocation, Tag.Builder>(this.f_126543_);
            super.m_6865_(cache);
        }

        @Nonnull
        public TagsProvider.TagAppender<Fluid> m_206424_(@Nonnull TagKey<Fluid> tag) {
            return super.m_206424_(tag);
        }

        public List<ResourceLocation> getTagInfo(TagKey<Fluid> tag) {
            TagsProvider.TagAppender<Fluid> builder = this.m_206424_(tag);
            return builder.getInternalBuilder().m_13330_().filter(p -> p.f_13338_() instanceof Tag.ElementEntry).map(p -> new ResourceLocation(((Tag.ElementEntry)p.f_13338_()).toString())).collect(Collectors.toList());
        }

        @Nonnull
        public String m_6055_() {
            return CommonTagsProviderBase.this.mod.modid + " common fluid tags";
        }
    }
}

